local bottomMenu
local showOffWindow

local default_info = {
    {
        image = "",
        Title = "Welcome",
        description = "Welcome to Vexia Online!"
    },
}

function init()
    bottomMenu = g_ui.displayUI('bottommenu')

    showOffWindow = bottomMenu:recursiveGetChildById('showOffWindow')
    showOffWindow.title = showOffWindow:recursiveGetChildById('showOffWindowText')

    if default_info then
        local scrollable = showOffWindow:recursiveGetChildById('contentsPanel')
        local widget = g_ui.createWidget('ShowOffWidget', scrollable)
        local description = widget:recursiveGetChildById('description')
        local image = widget:recursiveGetChildById('image')

        math.randomseed(os.time())
        local randomIndex = math.random(1, #default_info)
        local randomItem = default_info[randomIndex]
        showOffWindow.title:setText(tr(randomItem.Title))
        image:setImageSource(randomItem.image)
        description:setText(tr(randomItem.description))
        widget:resize(widget:getWidth(), description:getHeight())
    end
    if g_game.isOnline() then
        hide()
    end
end

function terminate()
    bottomMenu:destroy()
end

function hide()
    bottomMenu:hide()
    bottomMenu:lower()
end

function show()
    bottomMenu:show()
    bottomMenu:raise()
    bottomMenu:focus()
end
