return {
    vsync                             = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            g_window.setVerticalSync(value)
        end
    },
    showFps                           = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            modules.client_topmenu.setFpsVisible(value)
        end
    },
    showPing                          = {
        value = false
    },
    fullscreen                        = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            g_window.setFullscreen(value)
        end
    },
    classicControl                    = {
        -- Enabled by default for classic 7.72 look
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            -- Update the mouseControlMode based on this option
            -- 0 = Regular Controls, 1 = Classic Controls, 2 = Left Smart-Click
            local mouseControlMode = 0
            if value == true then
                mouseControlMode = 1 -- Classic Controls
            elseif options.smartLeftClick.value == true then
                mouseControlMode = 2 -- Left Smart-Click
            else
                mouseControlMode = 0 -- Regular Controls
            end
            
            -- Update the value in options table first
            options.mouseControlMode.value = mouseControlMode
            
            -- Then update settings
            g_settings.set('mouseControlMode', mouseControlMode)
            
            -- Update loot control visibility (only visible for Classic Controls)
            local lootControlModeCombobox = panels.generalPanel:recursiveGetChildById('lootControlMode')
            if lootControlModeCombobox then
                lootControlModeCombobox:setVisible(mouseControlMode == 1)
            end
            
            -- Update the combobox UI
            local mouseControlModeCombobox = panels.generalPanel:recursiveGetChildById('mouseControlMode')
            if mouseControlModeCombobox then
                mouseControlModeCombobox:setCurrentOption(mouseControlMode, true)
            end
        end
    },
    smartLeftClick                    = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            -- Update the mouseControlMode based on this option
            -- 0 = Regular Controls, 1 = Classic Controls, 2 = Left Smart-Click
            local mouseControlMode = 0
            if options.classicControl.value == true then
                mouseControlMode = 1 -- Classic Controls
            elseif value == true then
                mouseControlMode = 2 -- Left Smart-Click
            else
                mouseControlMode = 0 -- Regular Controls
            end
            
            -- Update the value in options table first
            options.mouseControlMode.value = mouseControlMode
            
            -- Then update settings
            g_settings.set('mouseControlMode', mouseControlMode)
            
            -- Update loot control visibility (only visible for Classic Controls)
            local lootControlModeCombobox = panels.generalPanel:recursiveGetChildById('lootControlMode')
            if lootControlModeCombobox then
                lootControlModeCombobox:setVisible(mouseControlMode == 1)
            end
            
            -- Update the combobox UI
            local mouseControlModeCombobox = panels.generalPanel:recursiveGetChildById('mouseControlMode')
            if mouseControlModeCombobox then
                mouseControlModeCombobox:setCurrentOption(mouseControlMode, true)
            end
        end
    },
    mouseControlMode                  = {
        value = 1, -- Default to "Classic Controls" (7.72 authentic)
        action = function(value, options, controller, panels, extraWidgets)
            -- Update the underlying options values first
            -- 0 = Regular Controls, 1 = Classic Controls, 2 = Left Smart-Click
            if value == 0 then
                options.classicControl.value = false
                options.smartLeftClick.value = false
                g_settings.set('classicControl', false)
                g_settings.set('smartLeftClick', false)
            elseif value == 1 then
                options.classicControl.value = true
                options.smartLeftClick.value = false
                g_settings.set('classicControl', true)
                g_settings.set('smartLeftClick', false)
            elseif value == 2 then
                options.classicControl.value = false
                options.smartLeftClick.value = true
                g_settings.set('classicControl', false)
                g_settings.set('smartLeftClick', true)
            end
            
            -- Schedule UI updates to ensure they happen after value updates
            scheduleEvent(function()
                -- Update the mouseControlMode combobox
                local mouseControlModeCombobox = panels.generalPanel:recursiveGetChildById('mouseControlMode')
                if mouseControlModeCombobox then
                    -- Force the combobox to select the right option
                    for i = 0, 2 do
                        if i == value then
                            mouseControlModeCombobox:setCurrentOptionByData(i)
                            break
                        end
                    end
                end
                
                -- Update loot control mode visibility (only visible for Classic Controls)
                local lootControlModeCombobox = panels.generalPanel:recursiveGetChildById('lootControlMode')
                if lootControlModeCombobox then
                    lootControlModeCombobox:setVisible(value == 1)
                end
            end, 50)
        end
    },
    lootControlMode                   = {
        value = 0, -- Default to "Loot: Right"
        action = function(value, options, controller, panels, extraWidgets)
            -- We need a small delay to ensure the UI updates correctly
            scheduleEvent(function()
                -- Update the lootControlMode combobox - get it fresh each time
                local lootControlModeCombobox = panels.generalPanel:recursiveGetChildById('lootControlMode')
                if lootControlModeCombobox then
                    -- Force the combobox to select the right option
                    for i = 0, 2 do
                        if i == value then
                            lootControlModeCombobox:setCurrentOptionByData(i)
                            break
                        end
                    end
                end
            end, 50)
        end
    },
    returnDisablesChat                = false,
    smartWalk                         = false,
    autoChaseOverride                 = true,
    moveStack                         = false,
    showStatusMessagesInConsole       = true,
    showEventMessagesInConsole        = true,
    showInfoMessagesInConsole         = true,
    showTimestampsInConsole           = true,
    showLevelsInConsole               = true,
    showPrivateMessagesInConsole      = true,
    showOthersStatusMessagesInConsole = false,
    showPrivateMessagesOnScreen       = true,
    showLootMessagesOnScreen          = true,
    showHighlightedUnderline          = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            local settings = g_settings.getNode('game_console') or {}
            settings.showHighlightedUnderline = value
            g_settings.setNode('game_console', settings)
            if modules and modules.game_console and modules.game_console.setShowHighlightedUnderline then
                modules.game_console.setShowHighlightedUnderline(value)
            end
        end
    },
    showOutfitsOnList                 = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            CharacterList.updateCharactersAppearances(value)
        end
    },
    openMaximized                     = false,
    backgroundFrameRate               = {
        value = 501,
        action = function(value, options, controller, panels, extraWidgets)
            local text, v = value, value
            if value <= 0 or value >= 501 then
                text = 'max'
                v = 0
            end

            panels.graphicsPanel:recursiveGetChildById('backgroundFrameRate'):setText(tr('Game framerate limit: %s', text))
            g_app.setMaxFps(v)
        end
    },
    enableLights                      = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            -- Forced ON for classic 7.72 anti-cheat: lights always enabled
            panels.gameMapPanel:setDrawLights(true)
        end
    },
    limitVisibleDimension             = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setLimitVisibleDimension(value)
        end
    },
    floatingEffect                    = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            g_map.setFloatingEffect(false)
        end
    },
    ambientLight                      = {
        value = 0,
        action = function(value, options, controller, panels, extraWidgets)
            -- Forced to 0 for classic 7.72 anti-cheat: pitch black environment
            panels.gameMapPanel:setMinimumAmbientLight(0)
            panels.gameMapPanel:setDrawLights(true)
        end
    },
    displayNames                      = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setDrawNames(value)

            if g_gameConfig.isDrawingInformationByWidget() then
                modules.game_creatureinformation.toggleInformation()
            end
        end
    },
    displayHealth                     = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setDrawHealthBars(value)

            if g_gameConfig.isDrawingInformationByWidget() then
                modules.game_creatureinformation.toggleInformation()
            end
        end
    },
    displayMana                       = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setDrawManaBar(value)

            if g_gameConfig.isDrawingInformationByWidget() then
                modules.game_creatureinformation.toggleInformation()
            end
        end
    },
    displayText                       = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            g_app.setDrawTexts(value)
        end
    },
    walkTurnDelay                     = { value = 200 },
    walkTeleportDelay                 = { value = 200 },
    walkStairsDelay                   = { value = 200 },
    hotkeyDelay                       = { value = 200 },
    crosshair                         = {
        -- Disabled by default for classic 7.72 look
        value = 'disabled',
        action = function(value, options, controller, panels, extraWidgets)
            local crossPath = '/images/game/crosshair/'
            local newValue = value
            if newValue == 'disabled' then
                newValue = nil
            end

            panels.gameMapPanel:setCrosshairTexture(newValue and crossPath .. newValue or nil)
            panels.interface:recursiveGetChildById('crosshair'):setCurrentOptionByData(newValue, true)
        end
    },
    enableHighlightMouseTarget        = false,
    showDragIcon        = {
        value = true,
    },
    antialiasingMode                  = {
        value = 1,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setAntiAliasingMode(value)
            panels.graphicsPanel:recursiveGetChildById('antialiasingMode'):setCurrentOptionByData(value, true)
        end
    },
    shadowFloorIntensity              = {
        value = 30,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setShadowFloorIntensity(1 - (value / 100))
        end
    },
    optimizeFps                       = {
        value = true,
        action = function(value, options, controller, panels, extraWidgets)
            g_app.optimize(value)
        end
    },
    forceEffectOptimization           = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            g_app.forceEffectOptimization(value)
        end
    },
    drawEffectOnTop                   = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            g_app.setDrawEffectOnTop(value)
        end
    },
    floorViewMode                     = {
        value = 1,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setFloorViewMode(value)
        end
    },
    floorFading                       = {
        value = 500,
        action = function(value, options, controller, panels, extraWidgets)
            panels.gameMapPanel:setFloorFading(tonumber(value))
        end
    },
    asyncTxtLoading                   = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            if g_game.isUsingProtobuf() then
                value = true
            elseif g_app.isEncrypted() then
                local asyncWidget = panels.graphicsPanel:recursiveGetChildById('asyncTxtLoading')
                asyncWidget:setEnabled(false)
                asyncWidget:setChecked(false)
                return
            end

            g_app.setLoadingAsyncTexture(value)
        end
    },
    hudScale                          = {
        event = nil,
        value = g_platform.isMobile() and 2 or 0,
        action = function(value, options, controller, panels, extraWidgets)
            value = value / 2

            if options.hudScale.event ~= nil then
                removeEvent(options.hudScale.event)
            end

            options.hudScale.event = scheduleEvent(function()
                g_app.setHUDScale(math.max(value + 0.5, 1))
                options.hudScale.event = nil
            end, 250)

            local hudWidget = panels.interfaceHUD:recursiveGetChildById('hudScale')
            hudWidget:setText(string.format('HUD Scale: %sx', math.max(value + 0.5, 1)))
        end
    },
    creatureInformationScale          = {
        value = g_platform.isMobile() and 2 or 0,
        action = function(value, options, controller, panels, extraWidgets)
            if value == 0 then
                value = g_window.getDisplayDensity() - 0.5
            else
                value = value / 2
            end
            g_app.setCreatureInformationScale(math.max(value + 0.5, 1))
            panels.interfaceHUD:recursiveGetChildById('creatureInformationScale'):setText(string.format(
                'Creature Information Scale: %sx', math.max(value + 0.5, 1)))
        end
    },
    staticTextScale                   = {
        value = g_platform.isMobile() and 2 or 0,
        action = function(value, options, controller, panels, extraWidgets)
            if value == 0 then
                value = g_window.getDisplayDensity() - 0.5
            else
                value = value / 2
            end
            g_app.setStaticTextScale(math.max(value + 0.5, 1))
            panels.interfaceHUD:recursiveGetChildById('staticTextScale'):setText(string.format('Message Scale: %sx',
                math.max(value + 0.5, 1)))
        end
    },
    animatedTextScale                 = {
        value = g_platform.isMobile() and 2 or 0,
        action = function(value, options, controller, panels, extraWidgets)
            if value == 0 then
                value = g_window.getDisplayDensity() - 0.5
            else
                value = value / 2
            end
            g_app.setAnimatedTextScale(math.max(value + 0.5, 1))
            panels.interfaceHUD:recursiveGetChildById('animatedTextScale'):setText(
                tr('Animated Message Scale: %sx', math.max(value + 0.5, 1)))
        end
    },
    showLeftExtraPanel                = false,
    showLeftPanel                     = false,
    showRightExtraPanel               = false,
    showSpellGroupCooldowns           = false,
    dontStretchShrink                 = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            addEvent(function()
                modules.game_interface.updateStretchShrink()
            end)
        end
    },
    setEffectAlphaScroll              = {
        value = 100,
        action = function(value, options, controller, panels, extraWidgets)
            g_client.setEffectAlpha(1.0)
        end
    },
    setMissileAlphaScroll             = {
        value = 100,
        action = function(value, options, controller, panels, extraWidgets)
            g_client.setMissileAlpha(1.0)
        end
    },
    distFromCenScrollbar              = 0,
    opacityScrollbar                  = 0,
    profile                           = {
        value = 1,
    },
    rightJoystick                     = {
        value = false,
        action = function(value, options, controller, panels, extraWidgets)
            if not g_platform.isMobile() then return end
            if value == true then
                modules.game_shortcuts.getPanel():breakAnchors()
                modules.game_shortcuts.getPanel():addAnchor(AnchorBottom, "parent", AnchorBottom)
                modules.game_shortcuts.getPanel():addAnchor(AnchorLeft, "parent", AnchorLeft)

                modules.game_joystick.getPanel():breakAnchors()
                modules.game_joystick.getPanel():addAnchor(AnchorBottom, "parent", AnchorBottom)
                modules.game_joystick.getPanel():addAnchor(AnchorRight, "parent", AnchorRight)
            else
                modules.game_joystick.getPanel():breakAnchors()
                modules.game_joystick.getPanel():addAnchor(AnchorBottom, "parent", AnchorBottom)
                modules.game_joystick.getPanel():addAnchor(AnchorLeft, "parent", AnchorLeft)

                modules.game_shortcuts.getPanel():breakAnchors()
                modules.game_shortcuts.getPanel():addAnchor(AnchorBottom, "parent", AnchorBottom)
                modules.game_shortcuts.getPanel():addAnchor(AnchorRight, "parent", AnchorRight)
            end
        end
    },
    showExpiryInInvetory              = false,
    showExpiryInContainers            = false,
    showExpiryOnUnusedItems           = false,
    framesRarity                      = 'None',
    autoSwitchPreset                  = false,
    listKeybindsPanel                 = {
        action = function(value, options, controller, panels, extraWidgets)
            listKeybindsComboBox(value)
        end
    },
    graphicalCooldown = false,
    cooldownSecond = false,
    actionBarShowBottom1 = false,
    actionBarShowBottom2 = false,
    actionBarShowBottom3 = false,
    actionBarShowLeft1 = false,
    actionBarShowLeft2 = false,
    actionBarShowLeft3 = false,
    actionBarShowRight1 = false,
    actionBarShowRight2 = false,
    actionBarShowRight3 = false,
    allActionBar46 = false,
    allActionBar13 = false,
    allActionBar79 = false,
    actionTooltip = false,
    showSpellParameters = false,
    showHKObjectsBars = false,
    showAssignedHKButton = false,
    actionBarBottomLocked = false,
    actionBarLeftLocked = false,
    actionBarRightLocked = false
}
